import 'ant-design-vue/dist/antd.min.css';
import 'element-plus/dist/index.css';

import '@oinone/kunlun-vue-ui-antd/dist/oinone-kunlun-vue-ui-antd.css';
import '@oinone/kunlun-vue-ui-el/dist/oinone-kunlun-vue-ui-el.css';
// import '@oinone/kunlun-vue-admin-layout/dist/oinone-kunlun-vue-admin-layout.css';
// import '@oinone/kunlun-vue-admin-base/dist/oinone-kunlun-vue-admin-base.css';

import '@oinone/kunlun-designer-common/dist/oinone-kunlun-designer-common.css';
import '@oinone/kunlun-model-designer/dist/oinone-kunlun-model-designer.css';
import '@oinone/kunlun-workflow-designer/dist/oinone-kunlun-workflow-designer.css';
import '@oinone/kunlun-workflow/dist/oinone-kunlun-workflow.css';
import '@oinone/kunlun-data-designer/dist/oinone-kunlun-data-designer.css';
import '@oinone/kunlun-microflow-designer/dist/oinone-kunlun-microflow-designer.css';
import '@oinone/kunlun-vue-ui-mobile-vant/dist/oinone-kunlun-vue-ui-mobile-vant.css';
// 前端示例
// import '@oinone/front-examples/dist/oinone-front-examples.css';


import 'reflect-metadata';
import { VueOioProvider, RuntimeContextManager } from '@oinone/kunlun-dependencies';
import ElementPlus from 'element-plus'
import { App } from 'vue'


// 界面设计器
import '@oinone/kunlun-ui-designer-dependencies';
// 打印设计器
import '@oinone/kunlun-print-designer-dependencies';
// 工作流执行
import '@oinone/kunlun-workflow';
// 流程设计器
import '@oinone/kunlun-workflow-designer';
// 模型设计器
import '@oinone/kunlun-model-designer';
// 数据可视化
import '@oinone/kunlun-data-designer';
// 数据可视化PC执行包
import '@oinone/kunlun-data-designer-open-pc';
// 集成设计器
import '@oinone/kunlun-eip-dependencies';
// AI设计器
import '@oinone/kunlun-ai-dependencies';
// 微流设计器
import '@oinone/kunlun-microflow-designer';
// 设计器公共依赖包
import '@oinone/kunlun-designer-common-ee';

//前端示例
import '@oinone/front-examples';



VueOioProvider({
  http: {
    url: window.location.origin,
    enableTranslate: true
  },
  browser: {
    title: 'Oinone - 构你想象!',
    favicon: 'https://pamirs.oss-cn-hangzhou.aliyuncs.com/pamirs/image/default_favicon.ico'
  },
}, [
  () => {
    const app = RuntimeContextManager.createOrReplace().frameworkInstance as App;
    // 全局挂载组件
    app.use(ElementPlus);
  }
]);
